#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_basebitmap.h"
#include "c4d_filterplugin.h"
#include "c4d_resource.h"
#include "operatingsystem.h"

LONG BitmapLoaderData::GetSaver(void)
{
	return 0;
}

Bool BitmapSaverData::Edit(BaseContainer *data)
{
	return TRUE;
}

LONG BitmapSaverData::GetMaxAlphas(BaseContainer *data)
{
	return 0;
}

Bool RegisterBitmapLoaderPlugin(LONG id, const String &str, LONG info, BitmapLoaderData *dat)
{
	if (!dat) return FALSE;

	BITMAPLOADERPLUGIN np;
	ClearMem(&np,sizeof(np));

	np.Destructor		= &BaseData::Destructor;
	np.info					= info;
	np.adr					= dat;
	np.Identify			= &BitmapLoaderData::Identify;
	np.Load					= &BitmapLoaderData::Load;

	return GeRegisterPlugin(C4DPL_BITMAPLOADER,id,str,&np,sizeof(np));
}

Bool RegisterBitmapSaverPlugin(LONG id, const String &str, LONG info, BitmapSaverData *dat, const String &suffix)
{
	if (!dat) return FALSE;

	BITMAPSAVERPLUGIN np;
	ClearMem(&np,sizeof(np));
	np.Destructor		= &BaseData::Destructor;
	np.info					= info;
	np.adr					= dat;
	np.suffix				= (String*)&suffix;
	np.Save					= &BitmapSaverData::Save;
	np.GetMaxAlphas = &BitmapSaverData::GetMaxAlphas;
	np.Edit					= &BitmapSaverData::Edit;
	return GeRegisterPlugin(C4DPL_BITMAPSAVER,id,str,&np,sizeof(np));
}

Bool RegisterSceneLoaderPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	SCENELOADERPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,g,NULL,0,emulation);
	np.Identify		= &SceneLoaderData::Identify;
	np.Load				= &SceneLoaderData::Load;
	return GeRegisterPlugin(C4DPL_SCENELOADER,id,str,&np,sizeof(np));
}

Bool RegisterSceneSaverPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, const String &suffix, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	SCENESAVERPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,g,NULL,0,emulation);
	np.suffix			= (String*)&suffix;
	np.Save				= &SceneSaverData::Save;
	return GeRegisterPlugin(C4DPL_SCENESAVER,id,str,&np,sizeof(np));
}
